"ATTACK" by "Victor Gijsbers"


Volume - Inclusions, programming variables and tricks

Include Plurality by Emily Short.
Include Dice-lock by S John Ross.

Before doing anything (this is the dice lock rule):
	lock the dice.


[When play begins, seed the random-number generator with 1081.] [If you want to use this for testing purposes, you must turn off the Dice-lock extension (although I don't understand how this is possible).]


To decide which number is the current_row: (- ct_1 -).




Volume - The Main System

[The Main System covers the basics of combat, and creates rulebooks for all other systems to fit into.]


Book - Minor Preliminaries


Chapter - Saying things

[This variable determines whether we get to see numerical output.]

The numbers boolean is a truth state that varies. The numbers boolean is usually true.

Switching the numbers off is an action out of world. Understand "numbers off" as switching the numbers off.

Carry out switching the numbers off (this is the standard switching the numbers off rule):
	take no time;
	now the numbers boolean is false;
	say "You will no longer see combat-related numbers.".

Switching the numbers on is an action out of world. Understand "numbers on" as switching the numbers on.

Carry out switching the numbers on (this is the standard switching the numbers on rule):
	take no time;
	now the numbers boolean is true;
	say "You will now see combat-related numbers.".



[I want "you", not "yourself".]

Rule for printing the name of yourself (this is the standard yourself to you rule):
	say "you".

[But we'll need to have tokens that print "You" rather than "you". For this reason, the following.]

To say CAP-attacker:
	if the global attacker is the player begin;
		say "[The global attacker]" in sentence case;
	otherwise;
		say "[The global attacker]";
	end if.

To say CAP-defender:
	if the global defender is the player begin;
		say "[The global defender]" in sentence case;
	otherwise;
		say "[The global defender]";
	end if.

The global actor is a person that varies.

To say CAP-actor:
	if the global actor is the player begin;
		say "[The global actor]" in sentence case;
	otherwise;
		say "[The global actor]";
	end if.

To say CAP-noun:
	if the noun is the player begin;
		say "[The noun]" in sentence case;
	otherwise;
		say "[The noun]";
	end if.

To say CAP-second noun:
	if the second noun is the player begin;
		say "[The second noun]" in sentence case;
	otherwise;
		say "[The second noun]";
	end if.



Chapter - Time

[Some of the actions should take no time; we wish to ensure that examining, smelling, and so on do not take a combat turn. This will allow the player to look around in combat, which is to be encouraged.]

Examining something is acting fast.
Taking inventory is acting fast.
Smelling is acting fast.
Smelling something is acting fast.
Looking is acting fast.
Looking under something is acting fast.
Listening is acting fast.
Listening to something is acting fast.
Thinking is acting fast.

This is the acting fast rule:
	if acting fast or the take no time boolean is true, rule succeeds.
		
The acting fast rule is listed before the every turn stage rule in the turn sequence rules.

The take no time boolean is a truth state that varies. The take no time boolean is false.

To take no time:
	now the take no time boolean is true.

This is the reset take no time boolean rule:
	now the take no time boolean is false.
	
The reset take no time boolean rule is listed before the generate action rule in the turn sequence rules.


Book - Dressing up the Person Class

Chapter - Health

A person has a number called health. The health of a person is usually 10. [health is a measure of health.]

Definition: A person is alive if its health is 1 or more. Definition: A person is killed if its health is 0 or less. [Once health drops to zero, you are dead. This holds true for both the player and his enemies.]

The printing dead property is a truth state that varies.
The printing dead property is true.

To say no dead property:
	now the printing dead property is false.

To say dead property:
	now the printing dead property is true.

Before printing the name of a killed person (called body) (this is the improper print dead property rule):
	if the printing dead property is true:
		if body is improper-named:
			say "dead [run paragraph on]".

After printing the name of a killed person (called body) (this is the proper print dead property rule):
	if the printing dead property is true:
		if body is proper-named:
			say "'s [if body is plural-named]bodies[otherwise]body[end if]".


Understand "dead" as a person when the item described is killed.
Understand "killed" as a person when the item described is killed.
Understand "body" as a person when the item described is killed.
Understand "body of" as a person when the item described is killed.
Understand "bodies" as a person when the item described is killed.
Understand "bodies of" as a person when the item described is killed.
Understand "corpse" as a person when the item described is killed.
Understand "alive" as a person when the item described is alive.
Understand "live" as a person when the item described is alive.
Understand "living" as a person when the item described is alive.
[Understand "[something related by equality]'s" as a person.] [Comment in once the corresponding bug in Inform has been fixed.]



[To make looting possible.]

The can't take people's possessions rule is not listed in any rulebook.

Check an actor taking (this is the can’t take living people’s possessions rule):
	let the local ceiling be the common ancestor of the actor with the noun;
	let H be the not-counting-parts holder of the noun;
	while H is not nothing and H is not the local ceiling:
		if H is an alive person, stop the action with library message taking action
			number 6 for H;
		let H be the not-counting-parts holder of H;

After examining a killed person (this is the give list of possession on dead person rule):
	if the number of things carried by the noun is at least one:
		say "On the [if the noun is plural-named]bodies[otherwise]body[end if] of [the noun] you also see [list of things carried by the noun with indefinite articles].".



A person has a number called permanent health. [The maximum you can regain with healing.]

When play begins (this is the set permanent health to initial health rule):
    repeat with the patient running through people begin;
        change the permanent health of the patient to the health of the patient;
    end repeat.

[We set the permanent health of each individual to the health it has at the beginning of the game. If we wish any character to start the game wounded or super-healthy, we will have to manually override this process.]

To restore the health of (patient - a person): change the health of the patient to the permanent health of the patient. 

To fully heal (patient - a person):
	if the permanent health of the patient is greater than the health of the patient:
		restore the health of the patient.

The healed amount is a number that varies. The healed amount is usually 0.

To heal (patient - a person) for (health - a number) health:
	let the health dummy be the permanent health of the patient minus the health of the patient;
	if health is less than the health dummy, now the health dummy is health;
	if the health dummy is less than 0, now the health dummy is 0;
	increase the health of the patient by the health dummy;
	now the healed amount is the health dummy. [For storage.]




Chapter - Basic Combat Stats

[Melee is a measure of fighting prowess. Higher melee means higher chance to hit.]

A person has a number called melee. The melee of a person is usually 0. 

[Defence is a measure of fighting prowess. Higher defence means less chance to get hit.]

A person has a number called defence. The defence of a person is usually 7.




Chapter - Factions

[Now we define factions. Everyone should belong to a faction. You can add as many factions as you like!]

Faction is a kind of value. The factions are friendly, passive and hostile.

A person has a faction. A person is usually passive.

The player is friendly.

[Now we define a relation between factions which indicates whether these factions will attack each other.]

Hating relates factions to each other. 

The verb to hate (he hates, they hate, he hated, it is hated, he is hating) implies the hating relation.

Friendly hates hostile. Hostile hates friendly.


[Now we need a phrase to decide whether people are going to battle each other in the current location. If not, we're not going to run all our ATTACK-machinery.]

To decide whether hate is present:
	if the player is friendly and at least one hostile alive person is enclosed by the location:
		if friendly hates hostile:
			decide yes; [This is only here for speed. It is the most common case where we decide yes.]
	repeat with X running through alive not passive persons enclosed by the location:
		repeat with Y running through alive persons enclosed by the location:
			if the faction of X hates the faction of Y:
				decide yes;
	decide no.
	


Book - Combat Round

Chapter - Combat States

[A person can have four combat states: Normal, Active, React and Reacted.

Normal: not doing anything in the current round.
Active: the one whose turn it is.
React: this person will be called on to react to the current action.
Reactive: this person has declared a reaction to the current action.]

Combat state is a kind of value. The combat states are Normal, Active, React and Reacted.

A person has a combat state. The combat state of a person is usually Normal.

A person has a person called the provoker.
A person has an action-name called the provocation.


Chapter - Setting up the Combat Order

Section - Initiative

[The person with the highest initiative is the one whose turn it is.]

A person has a number called the initiative. The initiative of a person is usually 0.

The initiative rules are a rulebook.

First initiative rule (this is the no low initiative trap rule):
	repeat with X running through all alive persons enclosed by the location:				
		if the initiative of X is less than -2, now the initiative of X is -2.
		
Initiative rule (this is the increase initiative every round rule):
	repeat with X running through all alive persons enclosed by the location:
		increase the initiative of X by 2.
	
Initiative rule (this is the random initiative rule):
	repeat with X running through all alive persons enclosed by the location:				
		increase the initiative of X by a random number between 0 and 2.

An aftereffects rule (this is the modify initiative based on combat results rule):
	if the final damage is greater than 0 begin;
		decrease the initiative of the global defender by 2;
	otherwise;
		decrease the initiative of the global attacker by 2;
	end if.


Section - Deciding the order

Table of Combat Order
Combatant	       Move Order
a person			a number
with 20 blank rows

To set up the combat order:
	consider the initiative rules;
	repeat through the Table of Combat Order:
		blank out the whole row;
	repeat with X running through all alive not passive persons enclosed by the location:
		choose a blank row in Table of Combat Order;
		now the Combatant entry is X;
		now the Move Order entry is the initiative of X;
[		say "[X]: [Move Order entry] "; [Use this for testing initiative rules.]]
		now the combat state of X is Normal;
	sort the Table of Combat Order in random order;
	sort the Table of Combat Order in reverse Move Order order.

[When play begins (this is the set up the combat order when play begins rule):
	set up the combat order.]



Chapter - The actual combat round


Section - Main combat round routines

This is the govern combat first part rule:
	if not acting fast and the take no time boolean is false:
		change the command prompt to ">";
		repeat with X running through all alive persons enclosed by the location:
			now the combat state of X is Normal;
		if hate is present:
			set up the combat order;
			handle the combat round.
			
The govern combat first part rule is listed before the parse command rule in the turn sequence rules.
	

This is the govern combat second part rule:
	if not acting fast and the take no time boolean is false:
		if the combat state of the player is React, now the combat state of the player is Reacted;
		have a reaction;
		run the combat.

The govern combat second part rule is listed before the acting fast rule in the turn sequence rules.


This is the dont parse command when not the players turn rule:
	if hate is present:
		if the combat state of the player is Normal:
			if not acting fast and the take no time boolean is false:
				stop the parser from running.

To stop the parser from running: (- EarlyInTurnSequence = false; -).

The dont parse command when not the players turn rule is listed before the parse command rule in the turn sequence rules.


Section - Handling the combat round

To handle the combat round:
	choose row 1 in the Table of Combat Order;
	now the global attacker is the combatant entry;
	now the initiative of the global attacker is 0;
	now the combat state of the global attacker is Active;
	if the global attacker is the player:
		change the command prompt to "Act>";
		stop;
	if the global attacker is alive, consider the combat AI rulebook of the global attacker;
	if the combat state of the player is React:
		change the command prompt to "React>";
		stop.


Section - Having a reaction

To have a reaction:
	repeat with N running from 1 to the number of rows in the Table of Combat Order:
		choose row N in the Table of Combat Order;
		if there is combatant in row N of the Table of Combat Order:
			if the combat state of the combatant entry is React:
				now the global attacker is the combatant entry;
				if the global attacker is alive, consider the combat AI rulebook of the global attacker;
				now the combat state of the global attacker is Reacted.


Section - Running the combat

The fight consequences variable is a truth state that varies. The fight consequences variable is false.

Table of Stored Combat Actions
Combat Speed		Combat Action
a number				a stored action
with 20 blank rows

To run the combat:
	now the fight consequences variable is true;
	sort the Table of Stored Combat Actions in Combat Speed order;
	repeat through the Table of Stored Combat Actions:
		try the Combat Action entry;
		blank out the whole row;
	now the fight consequences variable is false.







Book - Striking a Blow



Chapter - Striking a blow

The global attacker is a person that varies.
The global defender is a person that varies.

A weapon is a kind of thing. A weapon is either readied or not readied. A weapon is usually not readied.

The global attacker weapon is a weapon that varies.
The global defender weapon is a weapon that varies.

The to-hit roll is a number that varies. The to-hit modifier is a number that varies. The damage is a number that varies. The damage modifier is a number that varies. The final damage is a number that varies.

The reset combat variables is a rulebook.
The whether attacking begins is a rulebook.
The preliminary results of attacking is a rulebook.
The basic attack roll is a rulebook.
The attack modifiers is a rulebook.
The calculate results of the attack roll is a rulebook.
The show results of the attack roll is a rulebook.
The whether the attack hit is a rulebook.
The immediate results of hitting is a rulebook.
The basic damage roll is a rulebook.
The damage modifiers is a rulebook.
The calculate the final damage rules is a rulebook.
The show the final damage rules is a rulebook.
The aftereffects before flavour text is a rulebook.
The print flavour text is a rulebook.
The aftereffects is a rulebook.
The take away until attack circumstances is a rulebook.
The final blow report is a rulebook.

To make (attacker - a person) strike a blow against (defender - a person):
	now the global attacker is the attacker;
	now the global defender is the defender;
	have the global attacker start pressing the global defender;
	now the global attacker weapon is a random readied weapon enclosed by the global attacker;
	now the global defender weapon is a random readied weapon enclosed by the global defender;
	consider the reset combat variables rules;
	abide by the whether attacking begins rules; [Stage 1: Whether attacking begins]
	consider the preliminary results of attacking rules; [Stage 2: Preliminary results of attacking]
	consider the basic attack roll rules; [Stage 3: Basic attack roll]
	consider the attack modifiers rules; [Stage 4: Apply attack modifiers]
	consider the calculate results of the attack roll rules; [Stage 5: calculate results of the attack roll]
	consider the show results of the attack roll rules; [Stage 6: calculate results of the attack roll] [TEST: ; -> ., check whether new Inform still crashes]
	consider the whether the attack hit rules; [Stage 7: check and report whether we hit]
	if rule succeeded:
		consider the immediate results of hitting rules; [Stage 8: stage for some special effects]
		consider the basic damage roll rules; [Stage 9: roll the die for damage]
		consider the damage modifiers rules; [Stage 10: add or subtract modifiers]
		consider the calculate the final damage rules; [Stage 11: calculate final damage]
		consider the show the final damage rules; [Stage 12: print the damage]
	consider the aftereffects before flavour text rulebook; [Stage 13: anything that must happen before flavour text is printed.]
	consider the print flavour text rules; [Stage 14: flavour text]
	if the player is not killed, consider the aftereffects rulebook; [Stage 15: aftereffects]
	consider the take away until attack circumstances rulebook; [Stage 16: taking away anything that lasts until you have attacked]
	consider the final blow report rulebook. [Stage 17: any reporting left to be done]


Section - Reset combat variables

A reset combat variables rule (this is the standard reset combat variables rule):
	now the damage is 0; 
	now the final damage is 0;
	now the to-hit roll is 0;
	now the to-hit modifier is 0;
	now the damage modifier is 0.


Section - Basic attack roll

A basic attack roll rule (this is the standard attack roll rule):
	if the numbers boolean is true, say "[italic type]Rolling ";
	change the to-hit roll to a random number between 1 and 10;
	if the numbers boolean is true, say the to-hit roll, "[run paragraph on]".


Section - Attack modifier melee

An attack modifiers rule (this is the melee attack bonus rule):
		if the numbers boolean is true, say " + ", the melee of the global attacker, "[run paragraph on]";
		increase the to-hit modifier by the melee of the global attacker.


Section - Calculate results of attack roll

A calculate results of the attack roll rule (this is the standard calculate results of the attack roll rule):
	increase the to-hit roll by the to-hit modifier.


Section - Show results of attack roll

A show results of the attack roll rule (this is the standard show results of the attack roll rule): 
	if the numbers boolean is true, say " = ", the to-hit roll, ", [run paragraph on]".

Section - Whether the attack hits

A whether the attack hit rule (this is the standard whether the attack hit rule):
	if the to-hit roll is greater than the defence of the global defender begin;
		if the numbers boolean is true begin;
			if the global attacker is the player, say "you beat "; otherwise say "[the global attacker] beats ";
			say "[possessive of global defender] defence rating of ", the defence of the global defender, ".";
		end if;
		rule succeeds;
	otherwise;
		if the numbers boolean is true begin;
			if the global attacker is the player, say "you do ";
			if the global attacker is not the player, say "[the global attacker] does ";
			say "not overcome [possessive of global defender] defence rating of ", the defence of the global defender, "[roman type].";
		end if;
		rule fails;
	end if.

Section - Basic damage roll

First basic damage roll rule (this is the standard damage roll rule):
	now the damage is a random number between 1 and the damage die of the global attacker weapon;
	if the numbers boolean is true begin;
		if the global attacker is the player, say "You deal ", damage, "[run paragraph on]";
		if the global attacker is not the player, say "[The global attacker] deals ", damage, "[run paragraph on]";
	end if.



Section - Calculating the final damage

Calculate the final damage rule (this is the standard calculate the final damage rule):
	now the final damage is the damage plus the damage modifier;
	if the final damage is less than 0, now the final damage is 0.
	
	
Section - Showing the final damage

Show the final damage rule (this is the standard show the final damage rule):
	if the numbers boolean is true, say " = [bold type]", final damage, " damage[roman type][italic type], [run paragraph on]".

Last show the final damage rule (this is the standard report result of blow in numbers mode rule):
	if the numbers boolean is true:
		if the final damage is less than 1: [no damage]
			if the global defender is not the player, say "allowing [the global defender] to escape unscathed.[run paragraph on]";
			if the global defender is the player, say "allowing you to escape unscathed.[run paragraph on]";
		otherwise:
			if the final damage is less than the health of the global defender: [non-fatal]
				if the global defender is not the player, say "wounding [the global defender] to ", health of the global defender minus final damage, " health.[run paragraph on]" ;
				if the global defender is the player, say "wounding you to ", health of the global defender minus final damage, " health.[run paragraph on]";
			otherwise: [fatal]
				if the global defender is not the player:
					if the numbers boolean is true, say "killing [no dead property][the global defender][dead property].[run paragraph on]";
				otherwise:
					if the numbers boolean is true, say "killing you.";
		say "[roman type][paragraph break]".


Section - Aftereffects before flavour text

Aftereffects before flavour text (this is the subtract damage from health rule):
	decrease the health of the global defender by the final damage.


Section - Flavour text rules

The intervening flavour text are a rulebook. [Use this to intervene in the normal procedure.]
The flavour are a rulebook. [In non-fatal cases]
The fatal player flavour are a rulebook. [When the player is killed.]
The fatal flavour are a rulebook. [When someone else is killed.]

The attack move flavour are a rulebook. [When someone attacks, before the other person reacts.]

A print flavour text rule (this is the flavour text structure rule):
	abide by the intervening flavour text rules;
	if the global defender is alive:
		consider the flavour rulebook;
	otherwise:
		if the global defender is the player, consider the fatal player flavour rulebook;
		if the global defender is not the player, consider the fatal flavour rulebook.

Last flavour rule (this is the basic flavour rule):
	if the final damage is greater than 0:
		say "[CAP-attacker] hit[s] [the global defender].[run paragraph on]";
	otherwise:
		say "[CAP-attacker] miss[es] [the global defender].[run paragraph on]";
	continue the action.

Last fatal player flavour rule (this is the basic fatal player flavour rule):
	say "You are killed by [the global attacker].".

Last fatal flavour rule (this is the basic fatal flavour rule):
	say "[CAP-attacker] kill[s] [no dead property][the global defender][dead property].".

Last attack move flavour rule (this is the basic attack move flavour rule):
	now the global actor is the actor;
	if the actor is not the player, say "[CAP-actor] lung[es] towards [the noun].[paragraph break]".
	
Section - Aftereffects

An aftereffects rule (this is the unready weapons of dead person rule):
	if the global defender is killed:
		repeat with X running through weapons enclosed by the global defender:
			now X is not readied.

Section - Final blow report

Last final blow report rule (this is the end reporting blow with paragraph break rule):
	say "[paragraph break]".







Book - Standard Combat Actions

Chapter - Waiting

Carry out an actor waiting (this is the waiting lets someone else go first rule):
	if the combat state of the actor is Active:
		let Y be 0;
		repeat with X running through all alive persons enclosed by the location:
			if X is not the actor:
				if the initiative of X is greater than Y, now Y is the initiative of X;
		now the initiative of the actor is Y - 2.


Chapter - Attacking

The block attacking rule is not listed in any rulebook.

Understand "a [thing]" as attacking.

Does the player mean attacking a killed person: it is unlikely.
Does the player mean attacking a person:
	if the faction of the player hates the faction of the noun:
		it is very likely.
[Does the player mean attacking a hostile alive person: it is likely.]

A check attacking rule (this is the only attack persons rule):
	if the noun is not a person:
		take no time;
		say "Things are not your enemies." instead.

A check attacking rule (this is the only attack the living rule):
	if the noun is not alive:
		take no time;	
		say "[The noun] is already dead." instead.

A check attacking rule (this is the do not kill yourself rule):
	if the noun is the player:
		take no time;
		say "You are not that desperate!" instead.

A check attacking rule (this is the do not attack friendly people rule):
	if the faction of the player is the faction of the noun:
		take no time;
		say "[The noun] is your friend, not your enemy!" instead.

A check attacking rule (this is the do not attack neutral people rule):
	if the faction of the player does not hate the faction of the noun:
		take no time;
		say "[The noun] is not your enemy." instead.

A check attacking rule (this is the cannot attack as reaction rule):
	if the combat state of the player is React:
		take no time;
		say "Attacking is an action, not a reaction." instead.

Carry out an actor attacking when the fight consequences variable is false (this is the standard attacking first phase rule):
	now the global attacker is the actor;
	now the global attacker weapon is a random readied weapon enclosed by the global attacker;
	consider the attack move flavour rulebook;
	choose a blank row in the Table of Stored Combat actions;
	now the Combat Speed entry is 10;
	now the Combat Action entry is the action of the actor attacking the noun;
	now the combat state of the noun is React;
	now the provoker of the noun is the actor;
	now the provocation of the noun is the attacking action.

Carry out an actor attacking when the fight consequences variable is true (this is the standard attacking second phase rule):
	if the actor is alive and the noun is alive, make the actor strike a blow against the noun.



Chapter - Concentrating

Concentrating is an action applying to nothing. Understand "concentrate" and "c" as concentrating.

A person has a number called concentration. The concentration of a person is usually 0.

First carry out an actor concentrating (this is the standard concentrating improves initiative rule):
	increase the initiative of the actor by the concentration of the actor.
		
Carry out an actor concentrating (this is the standard carry out concentrating rule):	
	increase the concentration of the actor by 1;
	if the concentration of the actor is greater than 3, now the concentration of the actor is 3.
	
Last report an actor concentrating (this is the standard concentrating prose rule):
	now the global actor is the actor;
	if the concentration of the actor is 1, say "[CAP-actor] concentrate[s], and [is-are] now mildly concentrated.";
	if the concentration of the actor is 2, say "[CAP-actor] concentrate[s], and [is-are] now quite concentrated.";
	if the concentration of the actor is 3, say "[CAP-actor] concentrate[s], and [is-are] now maximally concentrated.".

An attack modifiers rule (this is the concentration attack modifier rule):
	if the concentration of the global attacker is greater than 0 begin;
		let the first dummy be 0;
		if the concentration of the global attacker is 1, now the first dummy is 2;
		if the concentration of the global attacker is 2, now the first dummy is 4;
		if the concentration of the global attacker is 3, now the first dummy is 8;
		if the numbers boolean is true, say " + ", the first dummy, " (concentration)[run paragraph on]";
		increase the to-hit modifier by the first dummy;
	end if.

A damage modifiers rule (this is the concentration damage modifier rule):
	if the concentration of the global attacker is greater than 1 begin;
		let the first dummy be 0;
		if the concentration of the global attacker is 2, now the first dummy is 2;
		if the concentration of the global attacker is 3, now the first dummy is 4;
		if the numbers boolean is true, say " + ", the first dummy, " (concentration)[run paragraph on]";
		increase the damage modifier by the first dummy;
	end if.

An aftereffects rule (this is the lose concentration when hit rule):
	if the final damage is greater than 0 and the global defender is alive, let the global defender lose concentration.

A take away until attack circumstances rule (this is the lose concentration after attacking rule):
	now the concentration of the global attacker is 0.


[Losing concentration]

The lose concentration prose rules are a rulebook.

The concentration loser is a person that varies.

To let (the defender - a person) lose concentration:
	if the concentration of the defender is 0, continue the activity;
	now the concentration of the defender is 0;
	now the concentration loser is the defender;
	consider the lose concentration prose rules.
	
Last lose concentration prose rule (this is the standard lose concentration prose rule):
	if the concentration loser is the player, say " You lose your [bold type]concentration[roman type]![run paragraph on]";
	if the concentration loser is not the player, say " [The concentration loser] loses [bold type]concentration[roman type]![run paragraph on]".




Chance to win rule (this is the CTW concentration bonus rule):
	if the concentration of the global attacker is 1, increase the chance-to-win by 2;
	if the concentration of the global attacker is 2, increase the chance-to-win by 4;
	if the concentration of the global attacker is 3, increase the chance-to-win by 8.
	

Carry out an actor going (this is the lose concentration on going rule):
	now the concentration of the actor is 0.


Chapter - Parrying


Parrying is an action applying to nothing. Understand "parry" and "p" as parrying.

A person can be at parry or not at parry. A person is usually not at parry.

Check parrying (this is the cannot parry when not reacting rule):
	if the combat state of the player is not React:
		take no time;
		say "You parry, but there is no attack." instead.


Carry out an actor parrying (this is the parrying changes initiative rule):
	increase the initiative of the actor by 1.
	
Carry out an actor parrying (this is the standard carry out parrying rule):	
	now the actor is at parry.
	
Last report an actor parrying (this is the standard parry prose rule):	
	now the global actor is the actor;
	say "[CAP-actor] strike[s] up a defensive pose.".


An attack modifiers rule (this is the parry defence bonus rule):
	if the global defender is at parry begin;
		let n be the passive parry max of global attacker weapon;
		if the active parry max of global defender weapon is less than n, now n is the active parry max of global defender weapon;
		if the numbers boolean is true begin;
			if n is greater than 0, say " - ", n, " (defender parrying)[run paragraph on]";
			if n is 0 and active parry max of global defender weapon is 0 begin;
				say " - 0 (cannot parry with [global defender weapon])[run paragraph on]";
			otherwise;
				if n is 0, say " - 0 (cannot parry against [global attacker weapon])[run paragraph on]";
			end if;
		end if;
		decrease the to-hit modifier by n;
	end if.


A take away until attack circumstances rule (this is the no longer at parry after the attack rule):
	now the global defender is not at parry.


Best defender's action rule (this is the CTW parry bonus rule):
	let n be the passive parry max of global attacker weapon;
	if the active parry max of global defender weapon is less than n, now n is the active parry max of global defender weapon;
	if the best defence is less than n, now the best defence is n.



Chapter - Dodging


Dodging is an action applying to nothing. Understand "dodge" and "do" as dodging.

A person can be at dodge or not at dodge. A person is usually not at dodge.

Check dodging (this is the cannot dodge when not reacting rule):
	if the combat state of the player is not React:
		take no time;
		say "You dodge, but there is no attack." instead.
	
Carry out an actor dodging (this is the standard carry out dodging rule):	
	now the actor is at dodge.
	
Last report an actor dodging (this is the standard dodge prose rule):
	now the global actor is the actor;
	say "[CAP-actor] get[s] ready for quick evasive maneuvers.".

An attack modifiers rule (this is the dodge defence bonus rule):
	if the global defender is at dodge begin;
		let n be the dodgability of global attacker weapon;
		if the numbers boolean is true begin;
			if n is greater than 0, say " - ", n, " (defender dodging)[run paragraph on]";
			if n is 0, say " - 0 (cannot dodge)[run paragraph on]";
		end if;
		decrease the to-hit modifier by n;
	end if.

A take away until attack circumstances rule (this is the no longer at dodge after the attack rule):
	now the global defender is not at dodge.

Best defender's action rule (this is the CTW dodge bonus rule):
	let n be the dodgability of the stored_weapon;
	if the best defence is less than n, now the best defence is n.





Book - Artificial Intelligence

[Our standard AI works in three stages. In the first stage, we choose a person to attack--if we were to attack. In the second stage, we choose a weapon. In the third stage, we decide whether to attack or whether to do something else--like concentrating, dodging, readying a weapon, and so on.]

Chapter - The Tables

Table of AI Combat Person Options
Person Option					Weight
a person						a number
with 20 blank rows

Table of AI Combat Options
Option						Weight
a stored  action				a number
with 15 blank rows

Table of AI Combat Weapon Options
Weapon Option				Weight
a weapon					a number
with 10 blank rows



Section - Blanking out the Tables

To blank out the AI Combat Options:
	repeat through the Table of AI Combat Options:
		blank out the whole row.

To blank out the AI Combat Person Options:
	repeat through the Table of AI Combat Person Options:
		blank out the whole row.

To blank out the AI Combat Weapon Options:
	repeat through the Table of AI Combat Weapon Options:
		blank out the whole row.

Section - Useful variables

Stored_row is a number that varies.

Stored_person is a person that varies.

Stored_weapon is a weapon that varies.

Stored_action is a stored action that varies.


Section - Standard attacker AI

The standard_attacker is a rulebook.

A standard_attacker rule:
	have the AI select a target;
	if the found-a-target boolean is true begin;
		have the AI select a weapon;
		have the AI select an action;
		try the stored_action;
	end if.
	

Section - General AI definitions

A person has a rulebook called the combat AI rulebook. The combat AI rulebook of a person is usually the standard_attacker rulebook.









Chapter - First Stage - Choosing a Person

Chapter - The pressing relation

[Pressing is mostly just a way to remember who had been attacking whom. The AI prefers continuing to attack the same person.]

Pressing relates various people to various people. The verb to press (he presses, they press, he pressed, it is pressed, he is pressing) implies the pressing relation.

[This routine takes care of the pressing relations]

To have (A - a person) start pressing (B - a person):
	repeat with X running through all persons pressed by A:
		now A does not press X;
	now A presses B.


Section - Rulebook

The standard AI target select rules are a rulebook.

The found-a-target boolean is a truth state that varies.

To have the AI select a target:
	blank out the AI Combat Person Options;
	now the found-a-target boolean is false;
	repeat with X running through all alive persons enclosed by the location:
		if the faction of the global attacker hates the faction of X:
			now the found-a-target boolean is true;
			choose a blank Row in the Table of AI Combat Person Options;
			change Person Option entry to X;
			change Weight entry to 0;
			now stored_row is the current_row;
			now stored_person is X;
			consider the standard AI target select rules;
			[say "[Person Option entry]: [Weight entry]"; [for testing]]
	if the found-a-target boolean is true:
		sort the Table of AI Combat Person Options in random order;
		sort the Table of AI Combat Person Options in reverse Weight order;
		choose row one in the Table of AI Combat Person Options;
		now the global defender is the Person Option entry.

Section - Standard rules

A standard AI target select rule (this is the do not prefer passive targets rule):
	choose row stored_row in Table of AI Combat Person Options;
	if stored_person is passive, decrease the Weight entry by 5.	

A standard AI target select rule (this is the prefer targets you press rule):
	choose row stored_row in Table of AI Combat Person Options;
	if the global attacker presses stored_person, increase the Weight entry by 3.

A standard AI target select rule (this is the prefer those who press you rule):
	choose row stored_row in Table of AI Combat Person Options;
	if the stored_person presses the global attacker, increase the Weight entry by 1.

A standard AI target select rule (this is the prefer the player rule):
	choose row stored_row in Table of AI Combat Person Options;
	if the stored_person is the player, increase the Weight entry by 1.

A standard AI target select rule (this is the prefer the severely wounded rule):
	choose row stored_row in Table of AI Combat Person Options;
	if the health of stored_person times 2 is less than the permanent health of stored_person, increase the Weight entry by 2;
	if the health of stored_person times 4 is less than the permanent health of stored_person, increase the Weight entry by 4.

A standard AI target select rule (this is the prefer concentrated people rule):
	choose row stored_row in Table of AI Combat Person Options;
	increase the Weight entry by the concentration of the stored_person;
	if the concentration of the stored_person is 3, increase the Weight entry by 2.

A standard AI target select rule (this is the prefer those with good weapons rule):
	choose row stored_row in Table of AI Combat Person Options;
	let item be a random readied weapon enclosed by the stored_person;
	increase the Weight entry by the damage die of item divided by 2.

A standard AI target select rule (this is the do not prefer good parriers rule):
	choose row stored_row in Table of AI Combat Person Options;
	let item be a random readied weapon enclosed by the global attacker;
	let item2 be a random readied weapon enclosed by the stored_person;
	let n be the passive parry max of item;
	if the active parry max of item2 is less than n, now n is the active parry max of item2;
	if the dodgability of item is less than n:
		now n is n minus the dodgability of item;
	otherwise:
		now n is 0;
	decrease the Weight entry by n.

[The following rule makes the actor prefer people with low defence, unless he is concentrated, in which case he prefers people with high defence. Reason: if you managed to become concentrated, you should use that bonus against otherwise tough opponents.]

A standard AI target select rule (this is the do not prefer high defence unless concentrated rule):
	choose row stored_row in Table of AI Combat Person Options;
	let n be the defence of stored_person minus the melee of the global attacker;
	if n is less than 0, now n is 0;
	let m be the concentration of the global attacker minus 1;
	increase the Weight entry by n times m. [Negative if concentration = 0; 0 is concentration is 1; positive if concentration is 2 or 3.]

A standard AI target select rule (this is the randomise the target result rule):
	choose row stored_row in Table of AI Combat Person Options;
	increase the Weight entry by a random number between 0 and 4.



Chapter - Second Stage - Choosing a Weapon

The standard AI weapon select rules are a rulebook.

To have the AI select a weapon:
	if exactly one weapon is enclosed by the global attacker:
		now the stored_weapon is a random weapon enclosed by the global attacker;
	otherwise:
		blank out the AI Combat Weapon Options;
		repeat with X running through all weapons enclosed by the global attacker:
			choose a blank Row in the Table of AI Combat Weapon Options;
			change Weapon Option entry to X;
			change Weight entry to 0;
			now stored_row is the current_row;
			now stored_weapon is X;
			consider the standard AI weapon select rules;
[			say "[Weapon Option entry]: [Weight entry]"; [for testing]]
		sort the Table of AI Combat Weapon Options in random order;
		sort the Table of AI Combat Weapon Options in reverse Weight order;
		choose row one in the Table of AI Combat Weapon Options;
		now the stored_weapon is the Weapon Option entry. 


Section - Standard rules

A standard AI weapon select rule (this is the prefer lots of damage rule):
	choose row stored_row in Table of AI Combat Weapon Options;
	increase the Weight entry by the damage die of the Weapon Option entry.

A standard AI weapon select rule (this is the prefer low dodgability and passive parry rule):
	choose row stored_row in Table of AI Combat Weapon Options;
	let n be the dodgability of the Weapon Option entry;
	if the passive parry max of the Weapon Option entry is greater than n, now n is the passive parry max of the Weapon Option entry;
	decrease the Weight entry by n.

A standard AI weapon select rule (this is the prefer good active parry rule):
	choose row stored_row in Table of AI Combat Weapon Options;
	let n be the active parry max of the Weapon Option Entry divided by 2;
	increase the Weight entry by n.

A standard AI weapon select rule (this is the prefer good attack bonus rule):
	choose row stored_row in Table of AI Combat Weapon Options;
	let n be the weapon attack bonus of the Weapon Option entry times three;
	now n is n plus 1;
	now n is n divided by 2;
	increase the Weight entry by n.

A standard AI weapon select rule (this is the prefer readied weapon rule):
	choose row stored_row in Table of AI Combat Weapon Options;
	if the Weapon Option entry is readied:
		if the combat state of the actor is Active:
			increase the Weight entry by 3;
		if the combat state of the actor is React:
			increase the Weight entry by 1.
	
A standard AI weapon select rule (this is the prefer readied weapon if attacker almost dead rule):
	choose row stored_row in Table of AI Combat Weapon Options;
	if four times the health of the global attacker is less than the permanent health of the global attacker begin;
		if the Weapon Option entry is readied, increase the Weight entry by 2;
	end if.

A standard AI weapon select rule (this is the prefer readied weapon if defender almost dead rule):
	choose row stored_row in Table of AI Combat Weapon Options;
	if four times the health of the global defender is less than the permanent health of the global defender begin;
		if the Weapon Option entry is readied, increase the Weight entry by 2;
	end if.

A standard AI weapon select rule (this is the randomise the weapon result rule):
	choose row stored_row in Table of AI Combat Weapon Options;
	increase the Weight entry by a random number between 0 and 2.


Chapter - Third Stage - Choosing an Action

The standard AI action select rules are a rulebook.

To have the AI select an action:
	blank out the AI Combat Options;
	consider the standard AI action select rules;
	sort the Table of AI Combat Options in random order;
	sort the Table of AI Combat Options in reverse Weight order;
	choose row one in the Table of AI Combat Options;
	now the stored_action is the Option entry. 

Section - Standard select rules

[For every possible action, there MUST be a "first" rule adding it to the table.]

First standard AI action select rule (this is the consider attacking rule):
	choose a blank Row in the Table of AI Combat Options;
	change the Option entry to the action of the global attacker attacking the global defender;
	if the combat state of the global attacker is not React:
		change the Weight entry to 5;
	otherwise:
		change the Weight entry to -1000.

First standard AI action select rule (this is the consider concentrating rule):
	choose a blank Row in the Table of AI Combat Options;
	change the Option entry to the action of the global attacker concentrating;
	change the Weight entry to 3.

First standard AI action select rule (this is the consider dodging rule):
	choose a blank Row in the Table of AI Combat Options;
	change the Option entry to the action of the global attacker dodging;
	if the combat state of the global attacker is not React:
		change the Weight entry to -1000;
	otherwise:
		change the Weight entry to 5.

First standard AI action select rule (this is the consider parrying rule):
	choose a blank Row in the Table of AI Combat Options;
	change the Option entry to the action of the global attacker parrying;
	if the combat state of the global attacker is not React:
		change the Weight entry to -1000;
	otherwise:
		change the Weight entry to 5.

First standard AI action select rule (this is the consider readying rule):
	choose a blank Row in the Table of AI Combat Options;
	change the Option entry to the action of the global attacker readying the stored_weapon;
	change the Weight entry to 0.


Section - Calculating the chance to win

The chance to win rules is a rulebook.

The chance-to-win is a number that varies. The normalised chance-to-win is a number that varies.

First standard AI action select rule (this is the calculate the chance to win rule):
	consider the chance to win rules.

First chance to win rule (this is the CTW default rule):
	now the chance-to-win is 10.

Chance to win rule (this is the CTW melee bonus rule):
	increase the chance-to-win by the melee of the global attacker.

Chance to win rule (this is the CTW defence bonus rule):
	decrease the chance-to-win by the defence of the global attacker.
	
[Other rules are in the appropriate sections.]	

[Now we are going to calculate what the best defensive action of the global defender is, and we will use that to calculate the chance to win.]

The best defender's action rules are a rulebook.

The best defence is a number that varies. The best defence is usually 0.
	
Chance to win rule (this is the consider best defender's action rule):
	now the best defence is 0;
	consider the best defender's action rules;
	decrease the chance-to-win by the best defence.


Last chance to win rule (this is the normalised CTW rule):
	now the normalised chance-to-win is the chance-to-win;
	if the normalised chance-to-win is greater than 10, now the normalised chance-to-win is 10;
	if the normalised chance-to-win is less than 0, now the normalised chance-to-win is 0.


Section - Standard rules

A standard AI action select rule (this is the standard attack select rule):
	choose row with an Option of the action of the global attacker attacking the global defender in the Table of AI Combat Options;
	if the normalised chance-to-win is 0, change the Weight entry to -100;
	decrease the Weight entry by 5;
	increase the Weight entry by the normalised chance-to-win.

A standard AI action select rule (this is the standard concentration select rule):
	choose row with an Option of the action of the global attacker concentrating in the Table of AI Combat Options;
	increase the Weight entry by 5;
	decrease the Weight entry by the chance-to-win;
	if the concentration of the global attacker is 3, now the weight entry is -100.

A standard AI action select rule (this is the concentration influences attacking rule):
	choose row with an Option of the action of the global attacker attacking the global defender in the Table of AI Combat Options;
	increase the Weight entry by the concentration of the global defender;
	if the concentration of the global defender is 3, increase the Weight entry by 2.

A standard AI action select rule (this is the standard parry and dodge against attack select rule):
	if the provocation of the global attacker is the attacking action and the combat state of the global attacker is React:
		let d be 0;
		let p be 0;
		let item be a random readied weapon enclosed by the provoker of the global attacker;
		let item2 be a random readied weapon enclosed by the global attacker;
		increase d by the dodgability of item;
		let m be the passive parry max of item;
		if m is greater than active parry max of item2, now m is active parry max of item2;
		increase p by m;
		choose row with an Option of the action of the global attacker dodging in the Table of AI Combat Options;
		increase the weight entry by d;
		if d is not greater than p, increase the weight entry by -100;
		choose row with an Option of the action of the global attacker parrying in the Table of AI Combat Options;
		increase the weight entry by p;
		if p is 0, increase the weight entry by -100;
		if d is greater than p, increase the weight entry by -100.


A standard AI action select rule (this is the standard ready select rule):
	if the stored_weapon is readied begin;
		choose row with an Option of the action of the global attacker readying the stored_weapon in the Table of AI Combat Options;
		now the Weight entry is -100;
	otherwise;
		choose row with an Option of the action of the global attacker attacking the global defender in the Table of AI Combat Options;
		now the Weight entry is -100;
		choose row with an Option of the action of the global attacker concentrating in the Table of AI Combat Options;
		now the Weight entry is -100;
		choose row with an Option of the action of the global attacker readying the stored_weapon in the Table of AI Combat Options;
		increase the Weight entry by 5;		
	end if.




Last standard AI action select rule (this is the randomise the action result rule):
	repeat through the Table of AI Combat Options begin;
		increase the Weight entry by a random number between 0 and 5;
[		say "[Option entry]: [Weight entry][line break]"; [For testing]]
	end repeat.










Book - Weapons

Chapter - The weapon kind



[A readied weapon is one that is not just carried by the actor, but actually in use.]

A weapon has a number called the damage die. The damage die of a weapon is usually 6.

[The damage die is the die size used to calculate damage.]

A weapon has a number called the dodgability. The dodgability of a weapon is usually 2.

[The dodgability of a weapon is the bonus a defender gets against it when dodging.]

A weapon has a number called the passive parry max. The passive parry max is usually 2.

[The passive parry max is the maximum bonus a defender can get when parrying AGAINST this weapon.]

A weapon has a number called the active parry max. The active parry max is usually 2.

[The active parry max is the maximum bonus a defender can get when parrying WITH this weapon.]

A weapon has a number called the weapon attack bonus. The weapon attack bonus of a weapon is usually 0.

Section - Weapon attack bonus

An attack modifiers rule (this is the attack bonus from weapon rule):
	let item be a random readied weapon enclosed by the global attacker;
	let n be the weapon attack bonus of item;
	if the numbers boolean is true begin;
		if n is greater than 0, say " + ", n, " ([item] bonus)[run paragraph on]";
		if n is less than 0, say " - ", 0 minus n, " ([item] penalty)[run paragraph on]";
	end if;
	increase the to-hit modifier by n.

Chance to win rule (this is the CTW attack bonus from weapon rule):
	increase the chance-to-win by the weapon attack bonus of the stored_weapon.


Chapter - The ready action

Section - The action itself

Readying is an action applying to one touchable thing.

Understand "ready [weapon]" as readying.

Does the player mean readying a readied weapon: it is unlikely.

First carry out an actor readying (this is the implicit taking when readying rule):
	if the actor does not enclose the noun:
		try the actor taking the noun.

Carry out an actor readying (this is the carry out readying when enclosing rule):
	if the actor encloses the noun:
		now the noun is readied.

Last carry out an actor readying (this is the unready all other weapons rule):
	if the noun is readied begin;
		repeat with item running through things enclosed by the actor begin;
			if the item is not the noun and the item is readied, now the item is not readied;
		end repeat;
	end if.

Report an actor readying (this is the standard report readying rule):
	now the global actor is the actor;
	if the noun is readied:
		say "[CAP-actor] read[ies] [the noun].";
	otherwise:
		if the actor encloses the noun:
			say "[CAP-actor] fools around with [the noun], but fails to ready it.";
		otherwise:
			say "[CAP-actor] attempts to ready [the noun], but cannot get it.".


After printing the name of a readied weapon while taking inventory (this is the readied inventory listing rule):
	say " (readied)".

After dropping a readied weapon (this is the unready on dropping rule):
	now the noun is not readied; continue the action.

After putting on a readied weapon (this is the unready on putting on rule):
	now the noun is not readied; continue the action.

After inserting into a readied weapon (this is the unready on inserting rule):
	now the noun is not readied; continue the action.


Section - Natural weapons

A natural weapon is a kind of weapon.

A natural weapon is part of every person.

Instead of examining a natural weapon (this is the standard description of a natural weapon rule):
	say "Clenched fists, kicking feet--that kind of stuff.".

The damage die of a natural weapon is usually 3. The dodgability of a natural weapon is usually 2. The passive parry max of a natural weapon is usually 2. The active parry max of a natural weapon is usually 0.


Section - Natural weapons as a fallback option

First every turn rule (this is the ready natural weapons if no other weapon readied rule):
	repeat with X running through all alive persons enclosed by the location:
		if X encloses no readied weapon:
			let item be a random natural weapon part of X;
			now item is readied.

The ready natural weapons if no other weapon readied rule is listed in the when play begins rulebook.





Volume - Plug-ins


Chapter - Reloadable Weapons (Standard Plug-in)

Section - Reloading

A weapon has a number called the maximum shots. The maximum shots of a weapon is usually 0. A weapon has a number called the current shots. The current shots of a weapon is usually 0. A weapon has a number called the maximum load time. The maximum load time of a weapon is usually 0.  A weapon has a number called the current load time. The current load time of a weapon is usually 0.

Definition: a weapon is unloaded if its current shots is 0 and its maximum shots is not 0.

A weapon has a text called the shots text. The shots text of a weapon is usually "shots".
A weapon has a text called the reload text. The reload text of a weapon is usually "reload".
A weapon has a text called the reload stem text. The reload stem text of a weapon is usually "reload".
A weapon has a text called the out of ammo text. The out of ammo text of a weapon is usually "You pull the trigger, but nothing happens--you're out of ammo!".

[Maximum shots: number of rounds the weapon can be used when fully loaded. Current shots: number of shots still loaded. Maximum load time: number of rounds it takes to load the weapon. Current load time: number of rounds it still takes to load the weapon.]

[Set maximum shots to 0 for any weapon that shouldn't use these statistics. Set maximum load time to -1 in case a weapon cannot be reloaded. NEVER set maximum load time to 0 for a weapon with maximum shots not 0.]

[The basic system does NOT deal with ammo. Everyone is assumed to have infinite ammunition.]

After printing the name of a weapon (called item) when taking inventory (this is the show ammo in inventory rule):
	if the maximum shots of item is not 0:
		if the current shots of item is not 0:
			say " ([current shots of item] of [maximum shots of item] [shots text of item] left)";
		otherwise:
			if the maximum load time of item is not -1:
				say " (no [shots text of item] left; [current load time of item] rounds to [reload text of item])";
			otherwise:
				say " (no [shots text of item] left; cannot be [reload stem text of item]ed)".


An aftereffects rule (this is the decrease ammo rule):
	if the maximum shots of the global attacker weapon is greater than 0 begin;
		decrease the current shots of the global attacker weapon by 1;
	end if.

Check attacking (this is the cannot attack when out of ammo rule):
	let item be a random readied weapon enclosed by the player;
	if the maximum shots of item is greater than 0:
		if the current shots of item is not greater than 0:
			say "[out of ammo text of item][paragraph break]" instead.

Reloading is an action applying to one carried thing.

Understand "reload [weapon]" as reloading.

Does the player mean reloading an unloaded readied weapon enclosed by the player: it is very likely.
Does the player mean reloading an unloaded weapon enclosed by the player: it is likely.

Check reloading (this is the cannot reload weapons that use no ammo rule):
	if the maximum shots of the noun is 0:
		take no time;
		say "[The noun] does not use ammunition." instead;
	
Check reloading (this is the cannot reload unreloadable weapons rule):	
	if the maximum load time of the noun is -1:
		take no time;
		say "[The noun] cannot be [reload stem text of the noun]ed." instead;
	
Check reloading (this is the cannot reload fully loaded weapons rule):	
	if the current shots of the noun is the maximum shots of the noun:
		take no time;
		say "[The noun] is already loaded." instead.

Carry out an actor reloading (this is the ready upon reloading rule):
	now the noun is readied.
	
Carry out an actor reloading (this is the standard carry out reloading rule):	
	decrease the current load time of the noun by 1;
	if the current load time of the noun is less than 1:
		now the current shots of the noun is the maximum shots of the noun;
		now the current load time of the noun is the maximum load time of the noun.
	
Report an actor reloading (this is the standard report reloading rule):
	now the global actor is the actor;
	if the current load time of the noun is the maximum load time of the noun:
		say "[CAP-actor] [if the maximum load time of the noun is 1][reload text of the noun][s][otherwise]finish[es] [reload stem text of the noun]ing[end if] [the noun].";
	otherwise:
		say "[CAP-actor] [if the current load time of the noun plus 1 is the maximum load time of the noun]start[s][otherwise]continue[s][end if] [reload stem text of the noun]ing [the noun].".


	
	

Section - Reloading and choosing a weapon

[Weapons with high load times and limited ammo should not be given a penalty if they are already readied and full; some penalty if they are not readied; and a larger penalty if they are not readied and out of ammo.]

Standard AI weapon select rule (this is the do not choose an empty weapon that cannot be reloaded rule):
	choose row stored_row in Table of AI Combat Weapon Options;
	if the Weapon Option entry is unloaded:
		if the maximum load time of the Weapon Option entry is -1:
			decrease the Weight entry by 1000.

Standard AI weapon select rule (this is the do not prefer weapons that need to be reloaded rule):
	choose row stored_row in Table of AI Combat Weapon Options;
	if the Weapon Option entry is not readied or the current shots of Weapon Option entry is 0:
		if the maximum shots of the Weapon Option entry is not 0:
			if the maximum load time of the Weapon Option entry is greater than 0:
				let m be the maximum shots of the Weapon Option entry;
				let n be the maximum load time of the Weapon Option entry;
				let x be m times 10;
				let y be m + n;
				now x is x divided by y; [Now x is roughly 10 times the fraction of time spent shooting in a shoot-reload cycle.]
				now x is 10 minus x; [Now x is roughly 10 times the fraction of time NOT spent shooting in a shoot-reload cycle.]
				if the current shots of the Weapon option entry is not 0: [This means that the weapon is (somewhat) loaded, but not ready. Using such a weapon can be done without ever reloading it: we ready it, shoot until empty, then ready a new weapon. This is AS IF we had to reload for two rounds in order to shoot as many shots as the weapon currently has. We now calculate this, and if it's better than the previous calculation, we substitute it for it.]
					now n is 2;
					now m is the current shots of the Weapon option entry;
					let z be m times 10;
					let y be m + n;
					now z is z divided by y;
					now z is 10 minus z;
					if z is less than x, now x is z;
				decrease the Weight entry by x.
	
[Example: a weapon that takes 1 turn to reload and gives you 1 shot gets a -5 penalty. A weapon that takes 3 turns to reload and gives you 1 shot gets a -8 penalty. A weapon that takes 1 turn to reload and gives you 5 shots gets a -2 penalty. ]

[Weapons with 0 ammo and a maximum load time of -1 should NOT be chosen.]




First standard AI action select rule (this is the consider reloading rule):
	choose a blank Row in the Table of AI Combat Options;
	change the Option entry to the action of the global attacker reloading the stored_weapon;
	change the Weight entry to 0.

Standard AI action select rule (this is the do not reload weapons that do not use ammo rule):
	choose row with an Option of the action of the global attacker reloading the stored_weapon in the Table of AI Combat Options;
	if the maximum shots of the stored_weapon is 0:
		decrease the Weight entry by 1000.
				
Standard AI action select rule (this is the do not reload weapons that are not empty rule):
	choose row with an Option of the action of the global attacker reloading the stored_weapon in the Table of AI Combat Options;
	if the the current shots of the stored_weapon is greater than 0:
		decrease the Weight entry by 100.

Standard AI action select rule (this is the do not reload weapons that cannot be reloaded rule):
	choose row with an Option of the action of the global attacker reloading the stored_weapon in the Table of AI Combat Options;
	if the maximum load time of the stored_weapon is -1:
		decrease the Weight entry by 1000;
	
Standard AI action select rule (this is the do not attack with unloaded weapon rule):
	if the stored_weapon is unloaded:
		choose row with an Option of the action of the global attacker attacking the global defender in the Table of AI Combat Options;
		decrease the Weight entry by 1000.
		
Standard AI action select rule (this is the do not concentrate with unloaded weapon rule):		
	choose row with an Option of the action of the global attacker concentrating in the Table of AI Combat Options;
	if the stored_weapon is unloaded:
		decrease the Weight entry by 100.
		
Standard AI action select rule (this is the reload when you have an unloaded weapon rule):		
	choose row with an Option of the action of the global attacker reloading the stored_weapon in the Table of AI Combat Options;
	if the stored_weapon is unloaded:
		increase the Weight entry by 5.


Chapter - Tension (Standard Plug-in)

[Tension is a standard plug-in, since I believe almost any game will benefit from it. Tension is a kind of "drama manager" for combat: it makes sure that long periods in which no apparent progress is made--that is, in which no damage is done--are not experienced as boring, but rather as increasing the tension. The way it works is that every turn when no hit is scored, the tension (a number that varies) is increased by one. High tension gives everyone bonuses on the attack roll, thus increasing the likelihood that something will happen, and on the damage roll, thus increasing the stakes.

Tension also works as a check and balance on the combat system: if you have made it too hard for people to hit each other, tension will greatly alleviate this problem.]

The tension is a number that varies. The tension is usually 0.

Every turn (this is the standard increase or reset the tension rule):
	if not hate is present:
		now the tension is 0;
	otherwise:
		increase the tension by 1;
	if the tension is greater than 20, now the tension is 20.
	
An attack modifiers rule (this is the standard tension attack modifier rule):
	let the first dummy be 0;
	now the first dummy is the tension divided by 2;
	if the first dummy is not 0:
		if the numbers boolean is true, say " + ", the first dummy, " (tension)[run paragraph on]";
		increase the to-hit modifier by the first dummy.
		
A damage modifiers rule (this is the standard tension damage modifier rule):
	let the first dummy be 0;
	now the first dummy is the tension divided by 3;
	if the first dummy is not 0:
		if the numbers boolean is true, say " + ", the first dummy, " (tension)[run paragraph on]";
		increase the damage modifier by the first dummy.

An aftereffects rule (this is the standard reduce tension after hit rule):		
	if the final damage is greater than 0:
		now the tension is the tension minus 4;
		now the tension is the tension times 8;
		now the tension is the tension divided by 10;
		if the tension is less than 0, now the tension is 0.

	
[A hit must reduce the tension, but not necessarily completely down to 0. We want low tensions to be completely removed by a hit, but larger tension to be removed only partly. The standard rule leads to the following table:

0 -> 0
1 -> 0
2 -> 0
3 -> 0
4 -> 0
5 -> 0
6 -> 1
7 -> 2
8 -> 2
9 -> 3
10 -> 4
11 -> 4
12 -> 5
13 -> 6
14 -> 7
15 -> 7
16 -> 8
17 -> 9
18 -> 9
19 -> 10
20 -> 11

So if the current tension is 10, my attack will have an attack bonus of +5 and a damage bonus of +3. If I hit, the tension will drop to 4, will then be immediately raised to 5 by the every turn rule, and my opponent's attack the next round will be made at a +2 to attack and +1 to damage.

You can see that if the current tension is 10 and I am maximally concentrated, my attack is made at a gigantic +13 attack bonus, and will deliver a +7 damage bonus. ]
		
Chance to win rule (this is the CTW tension bonus rule):
	increase the chance-to-win by the tension divided by 2.

A standard AI action select rule (this is the tension influences attacking rule):
	choose row with an Option of the action of the global attacker attacking the global defender in the Table of AI Combat Options;
	increase the Weight entry by the tension divided by 4.






Volume - Testing Game

Chapter - Sample weapons

Section - Sword

A sword is a kind of weapon. The damage die of a sword is usually 7. The weapon attack bonus of a sword is usually 1. The passive parry max of a sword is usually 3. The active parry max of a sword is usually 4.


Flavour rule (this is the sword flavour rule):
	if the global attacker weapon is a sword begin;
		if the final damage is greater than 0 begin;
			say "[CAP-attacker] stick[s] [its-their] sword into [the global defender].[run paragraph on]";
		otherwise;
			say "[CAP-attacker] miss[es] [the global defender] by inches.[run paragraph on]";
		end if;
		stop the action;
	end if.



[Section - Dagger

A dagger is a kind of weapon. The damage die of a dagger is usually 5. The dodgability of a dagger is usually 1. The passive parry max of a dagger is usually 2. The active parry max of a dagger is usually 2.]


Section - Sawed-off shotgun

A sawed-off shotgun is a kind of weapon.

The damage die of a sawed-off shotgun is usually 6.
The weapon attack bonus of a sawed-off shotgun is 4.
The dodgability of a sawed-off shotgun is usually 0.
The passive parry max of a sawed-off shotgun is usually 0.
The active parry max of a sawed-off shotgun is usually 2.

The maximum shots of a sawed-off shotgun is usually 2.
The current shots of a sawed-off shotgun is usually 2.
The maximum load time of a sawed-off shotgun is usually 2.
The current load time of a sawed-off shotgun is usually 2.

Attack move flavour rule (this is the sawed-off shotgun attack move flavour rule):
	if the global attacker weapon is a sawed-off shotgun:
		say "[CAP-attacker] point[s] a sawed-off shotgun at [the noun], preparing to pull the trigger.[paragraph break]";
		rule succeeds.

Section - Crossbow

A crossbow is a kind of weapon.

The damage die of a crossbow is usually 8.
The weapon attack bonus of a crossbow is 1.
The dodgability of a crossbow is usually 1.
The passive parry max of a crossbow is usually 0.
The active parry max of a crossbow is usually 0.

The maximum shots of a crossbow is usually 1.
The current shots of a crossbow is usually 1.
The maximum load time of a crossbow is usually 3.
The current load time of a crossbow is usually 3.

Attack move flavour rule (this is the crossbow attack move flavour rule):
	if the global attacker weapon is a crossbow:
		say "[CAP-attacker] point[s] a crossbow at [the noun], preparing to pull the trigger.[paragraph break]";
		rule succeeds.
		
The shots text of a crossbow is usually "arrows".
The reload text of a crossbow is usually "reload".
The out of ammo text of a crossbow is usually "You pull the trigger, but nothing happens--the crossbow has not been loaded!".


Chapter - First test game

[The Arena is a room.

The health of the player is 20.

Karl is a person. Karl is in the Arena. Karl carries a sawed-off shotgun. Karl carries a sword. Karl carries a dagger. Karl is hostile.

Kim is a person. Kim is in the Arena. Kim is hostile. Kim carries a dagger.

[The battle staff of ultimate booming is a weapon. Kim carries the battle staff. The damage die of the battle staff is 10. The weapon attack bonus of the battle staff is 6. The maximum shots of the battle staff is 50. The current shots of the battle staff is 1. The maximum load time of the battle staff is -1.]


[John is a person. John is in the Arena. John carries a dagger. John is friendly. [Uncomment for a 2 vs 2 battle.]]

When play begins:
	now a random sawed-off shotgun carried by Karl is readied.

In the arena is a sword.

The player carries a dagger and a sawed-off shotgun. The player carries a crossbow.

The player wears the coat. [Your chance to be a turncoat!]

Instead of turning the coat:
	if the player is friendly:
		now the player is hostile;
	otherwise:
		now the player is friendly.]


Chapter - Second test game		
		
Cave is a room. [The player is in the cave.]
The health of the player is 20.

A mace is a kind of weapon.

The unwieldy mace is a mace. The weapon attack bonus of the unwieldy mace is -1. The unwieldy mace is readied. The player carries the unwieldy mace.

The goblin is in the cave. The goblin is hostile.
The goblin carries a mace called the goblin's mace. The melee of the goblin is -1.

A fatal flavour rule (this is the fatal goblin rule):
	if the global defender is the goblin:
		say "[if the global attacker weapon is a mace]With a sweeping blow, [possessive of the global attacker] mace smashes into the goblin's head[otherwise][The global attacker] land[s] a furious blow on the goblin's head[end if], ending its beastly existence. Wow! A kill! You feel powerful.[run paragraph on]";
		rule succeeds.

A fatal player flavour rule (this is the fatal player goblin rule):
	if the global attacker is the goblin:
		say "Impossible! You stare in disbelief as the goblin[if the global attacker weapon is a mace]'s mace moves towards your face, unstoppable and unstopped[otherwise] hits you square between the eyes[end if], ending all your dreams of fame and treasure.[paragraph break]Killed by the first goblin in the first room of the dungeon. If only you had listened to your mother.";
		rule succeeds.

An attack move flavour rule (this is the goblin attacks rule):
	if the global attacker is the goblin:
		say "[one of]The[or]Smiling wickedly, the[or]With a scream, the[or]Just when you notice your shoe laces are untied, the[as decreasingly likely outcomes] goblin [one of]jumps forward to attack[or]attacks[or]advances towards[at random] [the global defender].";
		rule succeeds.

A flavour rule (this is the goblin defender flavour rule):			
	if the global defender is the goblin and the global attacker is the player:
		if the final damage is greater than 0:
			say "You score a [if the final damage is greater than 3]brilliant [end if]hit against the goblin[if the final damage is greater than 2], who screams in pain[end if]![run paragraph on]";
			rule succeeds;
		otherwise:
			say "[if the goblin is at dodge]The goblin dances out of the way of your clumsy blow[otherwise if the goblin is at parry]The goblin stops your attack with his weapon[otherwise]You attack, but... a miss! How unseemly[end if].[run paragraph on]";
			rule succeeds.
			
A flavour rule (this is the goblin attacker flavour rule):
	if the global attacker is the goblin:
		if the final damage is greater than 0:
			say "The horrible little creature manages to hit you [one of]in the stomach, sending you reeling[or]on your left leg[or]on your behind when you try a fancy Star Wars move[at random].[run paragraph on]";
			rule succeeds;
		otherwise:
			say "[if the player is at dodge]You easily avoid the goblin's flimsy attacks[otherwise if the player is at parry]Clang! You sweep away your enemy's attack and move in for the kill[otherwise]'You'll never get me, hellspawn!', you cry as the yellow demon unsuccessfully attempts to end your life[end if].[run paragraph on]";
			rule succeeds.
			
Report an actor parrying (this is the do not report goblin parry rule):
	if the actor is the goblin:
		rule succeeds.

Report an actor dodging (this is the do not report goblin dodge rule):
	if the actor is the goblin:
		rule succeeds.

Report an actor concentrating (this is the goblin concentrating prose rule):
	if the actor is the goblin:
		now the global actor is the actor;
		if the concentration of the actor is 1, say "The goblin starts chanting in a low voice.";
		if the concentration of the actor is 2, say "The goblin's chant rises in volume[one of]--he sounds like a shaman you once saw on Discovery[or][stopping].";
		if the concentration of the actor is 3, say "The goblin's entrancing song rises to a feverish pitch; his eyes shine with demonic purpose.";
		rule succeeds.				

Lose concentration prose rule (this is the goblin lose concentration prose rule):
	if the concentration loser is the goblin:
		say " The goblin's [bold type]trance[roman type] is broken![run paragraph on]";
		rule succeeds.


Every turn (this is the player death rule):
	if the player is killed:
		end the game saying "You were killed by [the global attacker].".

When play begins:
	now the numbers boolean is false.
	

Section - Retreat
	
Small cavern is north of cave.

Before going (this is the cannot go when in a fight rule):
	if hate is present:
		take no time;
		say "You cannot abandon a fight so easily!" instead.



Grassy meadow is a room. "The cave gapes to the north."
The player is in grassy meadow.
Cave is north of grassy meadow.

Retreating is an action applying to nothing.
Understand "retreat" as retreating.

A person is either retreater or not retreater. A person is usually not retreater.

The retreat location is a room that varies. The retreat location is Grassy meadow.

First carry out going (this is the set retreat location rule):
	now the retreat location is the location.

Check retreating (this is the cannot retreat when in the retreat location rule):
	if the retreat location is the location:
		take no time;
		say "You cannot retreat now." instead.
		
Check retreating (this is the cannot retreat when there are no enemies rule):
	if not hate is present:
		say "There's nothing here to retreat from." instead.
		
Check retreating (this is the cannot retreat as reaction rule):
	if the combat state of the player is not Active:
		take no time;
		say "You cannot retreat as a reaction--try to survive and run away on your own turn." instead.
	
Carry out retreating (this is the standard carry out retreat rule):
	say "Deciding that discretion is the better part of valour, you bravely run away.";
	now the player is retreater;
	repeat with X running through alive persons in the location:
		if X presses the player or the player presses X:
			now X does not press the player;
			now the player does not press X;
			if the faction of X hates the faction of the player:
				make X strike a blow against the player;
	if the player is alive, move the player to the retreat location;
	now the player is not retreater.


The boots of expeditious retreat are in grassy meadow. They are wearable and plural-named. The indefinite article is "the".

An attack modifiers rule (this is the boots of expeditious retreat grant better retreat rule):
	if the global defender is the player and the player is retreater:
		if the player wears the boots of expeditious retreat:
			if the numbers boolean is true, say " - 2 (boots of expeditious retreat)[run paragraph on]";
			decrease the to-hit modifier by 2.

Section - Frog warriors

A frog warrior is a kind of person.
A frog warrior is usually hostile.
The health of a frog warrior is usually 4.
The melee of a frog warrior is usually -2.
The defence of a frog warrior is usually 8.

A small frog spear is a kind of weapon.
Every frog warrior carries a small frog spear.
The damage die of a small frog spear is usually 2.

A frog warrior called the frog commander is in the Small cavern.
A frog warrior called the limping frog warrior is in the Small cavern.
A frog warrior called the stout frog warrior is in the Small cavern.
A frog warrior called the old frog warrior is in the Small cavern.
A frog warrior called the bright green frog warrior is in the Small cavern.

Standard AI weapon select rule (this is the frogs use spears rule):
	choose row stored_row in Table of AI Combat Weapon Options;
	if the Weapon Option entry is a small frog spear:
		if the global attacker is a frog warrior:
			increase the Weight entry by 100.
			
Standard AI action select rule (this is the frogs love concentrating rule):
	choose row with an Option of the action of the global attacker concentrating in the Table of AI Combat Options;
	if the global attacker is a frog warrior:
		increase the Weight entry by 5.

Section - Shout

Shouting is an action applying to nothing.
Understand "shout" as shouting.

The shout-victims is a list of persons that varies.

Carry out shouting (this is the standard shouting rule):
	now the concentration of the player is 0;
	truncate shout-victims to 0 entries;
	repeat with X running through alive persons enclosed by the location:
		if the concentration of X is not 0:
			if a random chance of 1 in 2 succeeds:
				now the concentration of X is 0;
				add X to shout-victims;
	say "'[one of]BWAAH[or]BLEH[or]GRAAH[or]WRUGH[at random]!', you shout as loudly as you can. [if the number of entries in shout-victims is 0]Unfortunately, nobody is very impressed[otherwise if the number of entries in shout-victims is 1]This startles [shout-victims with definite articles] so much that [it-they] lose[s] concentration[otherwise]This startles [shout-victims with definite articles] so much that they lose concentration[end if].".	


Section - Healing

The shrine is in Grassy meadow. It is fixed in place.

Instead of examining the shrine:
	say "If you pray in this location, the world's wounds will be healed.".

Praying is an action applying to nothing.
Understand "pray" as praying.

Carry out praying (this is the pray in grassy meadow rule):
	if the location is the Grassy Meadow:
		say "God's blessing descends onto the world, healing friend and foe alike.";
		repeat with X running through alive persons:
			fully heal X;
		rule succeeds.

Last carry out praying (this is the pray somewhere else rule):
	say "Words without thoughts never to heaven go.".


A health potion is a kind of thing.

Instead of drinking a health potion:
	heal the player for 6 health;
	say "You drink the health potion, [if the healed amount is 0]but you were already at full health[otherwise if the health of the player is less than the permanent health of the player]partially restoring your health[otherwise]restoring your health[end if].";
	if the combat state of the player is react:
		now the player is adrinking.

The player carries 3 health potions.

A person can be either adrinking or not adrinking. A person is usually not adrinking.

An attack modifiers rule (this is the drinking is not a good defence rule):
	if the global defender is adrinking:
		if the numbers boolean is true, say " + 2 (defender drinking a potion)[run paragraph on]";
		increase the to-hit modifier by 2.	

A take away until attack circumstances rule (this is the defender no longer adrinking rule):
	now the global defender is not adrinking.

Include Basic Screen Effects by Emily Short.

Table of Fancy Status
left	central	right
"[bold type][location of the player][roman type]"	"Tension: [tension]"	"Score: [score]/100"
"You [harm status], and armed with [a random readied weapon enclosed by the player]."	""	""

Rule for constructing the status line:
	fill status bar with Table of Fancy Status;
	rule succeeds. 

To say harm status:
	if the numbers boolean is false:
		say "are ";
		let n be 10 times the health of the player;
		now n is n divided by the permanent health of the player;
		if n is:
			-- 10: say "unharmed";
			-- 9: say "scratched";
			-- 8: say "lightly wounded";
			-- 7: say "wounded";
			-- 6: say "wounded";
			-- 5: say "severely wounded";
			-- 4: say "severely wounded";
			-- 3: say "[bold type]bleeding copiously[roman type]";
			-- 2: say "[bold type]losing limbs[roman type]";
			-- otherwise: say "[bold type]dying[roman type]";
	otherwise:
		say "are at [health of the player] of [permanent health of the player] health".

Section - A blade in the dark

The treasure chest is in small cavern. It is fixed in place, container, closed and openable.

Check opening the treasure chest (this is the cannot open chest in combat rule):
	if hate is present:
		take no time;
		say "Not in the presence of enemies!" instead.

A dagger is a kind of weapon.

The damage die of a dagger is usually 2.
The weapon attack bonus of a dagger is usually -2.
The dodgability of a dagger is usually 3.
The passive parry max of a dagger is usually 1.
The active parry max of a dagger is usually 1.

The gilded dagger is a dagger. The gilded dagger is in the treasure chest.

An attack modifiers rule (this is the dagger extra tension attack bonus rule):
	if the global attacker weapon is a dagger:
		let n be 0;
		now n is the tension divided by 2;
		if n is not 0:
			if the numbers boolean is true, say " + ", n, " (dagger benefits from tension)[run paragraph on]";
			increase the to-hit modifier by n.
		
A damage modifiers rule (this is the dagger extra tension damage bonus rule):
	if the global attacker weapon is a dagger:
		let n be 0;
		now n is the tension divided by 3;
		if n is not 0:
			if the numbers boolean is true, say " + ", n, " (dagger benefits from tension)[run paragraph on]";
			increase the damage modifier by n.

	
To say tension:
	if the numbers boolean is true:
		say tension;
	otherwise:
		if tension is greater than 15:
			say "very high";
		if tension is greater than 10 and tension is less than 16:
			say "high";
		if tension is greater than 5 and tension is less than 11:
			say "moderate";
		if tension is less than 6:
			say "low".


The cloak of shadows is in the treasure chest. It is wearable.

A person is either shadowed or not shadowed. A person is usually not shadowed.

First standard_attacker rule (this is the do nothing when all enemies shadowed rule):
	let p be false;
	let q be false;
	repeat with X running through all alive persons enclosed by the location:
		if the faction of the global attacker hates the faction of X:
			now p is true;
			if X is not shadowed:
				now q is true;
	if p is true and q is false:
		say "[CAP-attacker] [one of]remains unaware of your presence[or]looks around suspiciously[or]sighs in boredom[as decreasingly likely outcomes].";
		rule succeeds.
	
Every turn when the player wears the cloak of shadows (this is the blend into shadows rule):
	if not hate is present:
		if the player is not shadowed:
			now the player is shadowed;
			say "You blend into the shadows.";

An aftereffects rule (this is the attacking breaks shadowed rule):
	if the global attacker is the player:
		now the player is not shadowed.

The detection probability is a number that varies.
The detection rules are a rulebook.
	
Every turn when the player is shadowed (this is the possible detection rule):	
	if hate is present:
		consider the detection rules;
		let n be a random number between 1 and 100;
		if the detection probability is greater than n:
			now the player is not shadowed;
			say "You have been detected!";
		now the detection probability is 0.


A detection rule (this is the standard probability of detection rule):
	increase the detection probability by 6.
	
A detection rule (this is the tension increases probability of detection rule):
	increase the detection probability by the tension divided by 2.

Check concentrating (this is the cannot concentrate while shadowed rule):
	if the player is shadowed:
		take no time;
		say "You need all your concentration just to stay hidden." instead.

Section - Troll

Troll lair is north of small cavern.

A large troll is in troll lair. The large toll is a person.
The large troll is hostile.

The health of the large troll is 30.
The defence of the large troll is 8.

The large troll carries a huge club.
The huge club is a weapon.
The damage die of the huge club is 10.
The dodgability of the huge club is 5.
The passive parry max of the huge club is 0.
The active parry max of the huge club is 2.

Damage modifiers rule (this is the more damage from club rule):
	if the global attacker weapon is the huge club:
		increase the damage modifier by 3;
		if the numbers boolean is true:
			say " + 3 (huge club)[run paragraph on]".

Check readying the huge club:
	say "It's far too massive for you to use in combat." instead.


An attack modifiers rule (this is the troll attack bonus rule):
	if the global attacker is the large troll:
		let n be a random number between -4 and 10;
		increase the to-hit modifier by n;
		if the numbers boolean is true and n is greater than 0:
			say " + ", n, " (random troll bonus)[run paragraph on]";
		if the numbers boolean is true and n is less than 0:
			say " - ", 0 minus n, " (random troll bonus)[run paragraph on]".

Chance to win rule (this is the troll CTW rule):
	increase the chance-to-win by a random number between -4 and 10.

A standard AI action select rule (this is the troll attack select rule):
	choose row with an Option of the action of the global attacker attacking the global defender in the Table of AI Combat Options;
	increase the Weight entry by 2.



Slime-healing is an action applying to nothing.

Carry out the large troll slime-healing:
	say "The troll drools large amounts of slime over its arms, chest and leg. Wherever the slime touches its wounds, they close and apparently heal.";
	heal the large troll for 5 health.

Standard AI action select rule (this is the only the troll considers slime-healing rule):
	if the global attacker is the large troll:
		choose a blank Row in the Table of AI Combat Options;
		change the Option entry to the action of the global attacker slime-healing;
		change the Weight entry to 15;
		decrease the Weight entry by the health of the large troll;
		if a random chance of 4 in 5 succeeds, decrease the weight entry by 100;
		if the health of the global defender is less than 8:
			decrease the weight entry by 8 minus the health of the global defender.


Section - Victory

Every turn when in the grassy meadow (this is the victory rule):
	if there are no hostile alive persons:
		end the game saying "You emerge into the sunlight, victorious!".

	
Section - Test commands - Not for release

The dice lock rule is not listed in any rulebook.

When play begins, seed the random-number generator with 1081.

Plunking is an action applying to one thing.
Understand "plunk [something]" as plunking.

Carry out plunking:
	say "You plunk [the noun].";
	now the health of the noun is -5.

Plonking is an action applying to nothing.
Understand "plonk" as plonking.

Carry out plonking:
	say "These fools are no match for you, my lord!";
	repeat with X running through all alive persons enclosed by the location:
		if the faction of the player hates the faction of X:
			now the health of X is -5.

Section - Save and undo

Check saving the game (this is the can only save in meadow rule):
	if the location is not the grassy meadow:
		say "You can only save outside, where God can see you." instead.

Include Conditional Undo by Jesse McGrew.

Rule for deciding whether to allow undo (this is the no undoing during a fight rule):
	if hate is present:
		take no time;
		say "You cannot undo during a fight.";
		deny undo.

			
			
Section - Testing with killed

John is in the grassy meadow. John is a person.
John is hostile. The health of John is 1. The defence of John is 0.

Queen is in grassy meadow. Queen is proper-named and plural-named. Queen is a person.
	